/*
̃\[XR[h́ABSDCZXłB

Copyright (c) 2014, Norix
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this 
    list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/*
XV
2014/ 4/ 2	Norix	Ń[X
2014/ 4/18	Norix	CRCG[ĂŌ܂ŕϊ悤ɂ
					pf[^ubNoϊI悤ɂ
*/

#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<stdint.h>

#include	<string>
#include	<vector>

#include	"fileio.h"
#include	"pathlib.h"

static
Pathlib	pathlib;

std::vector<uint8_t>	bitstreambuffer;

static	const	int	GARBAGE_DATA_SIZE = 0x1600/2;	// 擪̃S~f[^̃TCY
static	const	int	GAP_DATA_SIZE = 128;			// SYNCf[^̍ŒTCY

int		bitstreampos = 0;
uint8_t	bitstreammask = 1;

int	ReadBits(int count)
{
	if (bitstreampos >= bitstreambuffer.size())
		return	-1;

	int	bit = 0;
	int	bit2 = 1;

	for (int i = 0; i < count; i++) {
		if (bitstreambuffer[bitstreampos] & bitstreammask) {
			bit |= bit2;
		}

		bit2 <<= 1;

		bitstreammask <<= 1;
		if (!bitstreammask) {
			bitstreammask = 1;
			bitstreampos++;
		}
	}

	return	bit;
}

int	SearchSync()
{
	int	count = 0;

	while (1) {
		int	bit = ReadBits(8);
		if (bit < 0) {
			return	-1;
		}

		if (bit == 0x55) {
			if (++count > GAP_DATA_SIZE)
				break;
		} else
		if (bit == 0xAA) {
			ReadBits(1);	// bit␳
			count = 0;
		} else {
			count = 0;
		}
	}

	// START MARKo($80)
	while (1) {
		int bit = ReadBits(2);
		if (bit < 0)
			return	-1;

		// 3T found
		if (bit == 2) {
			break;
		}
	}

	return	1;
}

int	ReadByte()
{
	uint8_t	data = 0;

	for (int i = 0; i < 8; i++) {
		int bit = ReadBits(2);
		if (bit < 0) {
			return	-1;
		}

		if (bit & 2) {
			data |= (1 << i);
		}
	}

	return	data;
}

uint16_t	CRC_check(uint8_t data, bool initialize = false)
{
	static uint16_t crc = 0;

	if (initialize) {
		crc = 0x1021;
	}

	uint8_t data_lsb = data;
	for (int i = 0; i < 8; i++) {
		uint8_t exr = data_lsb & 1;
		data_lsb >>= 1;

		if (crc & 0x8000) {
			exr ^= 1;
		}

		crc <<= 1;
		if (exr) {
			crc ^= 0x1021;
		}
	}

	return	crc;
}

int	main(int argc, char* argv[])
{
	if( argc < 2 ) {
		printf ("FDS image decoder (C)Norix,2014\n" );
		printf (" Usage : FDSdecoder filename\n");
		return	0;
	}

	{
		CFile	file;

		if (!file.Open(argv[1], "rb")) {
			fprintf (stderr, "ERROR : file not found. [%s]\n", argv[1]);
			return	1;
		}

		bitstreambuffer.resize(file.GetSize());

		if (!file.Read(&bitstreambuffer[0], file.GetSize())) {
			fprintf (stderr, "ERROR : file read error.\n");
			return	1;
		}
	}

	CFile	fdsoutput;

	std::string	name = Pathlib::SplitFilename (argv[1]);
	std::string	fdsname = name + ".fds";

	if (!fdsoutput.Open(fdsname.c_str(), "wb")) {
		fprintf (stderr, "ERROR : file open error.\n");
		return	1;
	}

	printf ("o̓t@C:%s\n", fdsname.c_str());
	printf ("ϊĂ܂...\n");

	fdsoutput.Putc('F');
	fdsoutput.Putc('D');
	fdsoutput.Putc('S');
	fdsoutput.Putc(0x1A);
	fdsoutput.Putc(1);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);
	fdsoutput.Putc(0);

	bitstreampos = 0;
	bitstreammask = 1;

	// S~f[^ǂݔ΂
	for (int i = 0; i < GARBAGE_DATA_SIZE; i++) {
		int	ret = ReadByte();
		if (ret < 0) {
			fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
			return	1;
		}
	}

	if (SearchSync() < 0) {
		fprintf (stderr, "ERROR : Syncf[^܂B(ERROR 21)\n");
		return	1;
	}

#if	0
	{
		// f[^Jn|Cg
		double	us = ((1.0 / (21.47727 / 112)) * (double)bitstreampos * 8 ) / 1000.0;
		printf ("HEAD TIME: %7.3fms\n", us);
	}
#endif

	bool sync = true;
	int	blocksize = 0;
	int	blocknum = 0;
	int	filenum = 0;
	int	fileindex = 0;
	int	outsize = 0;

	while (1) {
		if (!sync) {
			if (SearchSync() < 0) {
				if ((blocknum < 2) || (fileindex < filenum)) {
					fprintf (stderr, "ERROR : Syncf[^܂B%3d/%3d\n", fileindex, filenum);
					return	1;
				}
				break;
			}
			sync = true;
		}
		else
		{
			// Block ID
			int b = ReadByte();
			if (b < 0) {
				if ((blocknum < 2) || (fileindex < filenum)) {
					fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
				}
				goto	_CONVERT_EXIT;
			}

			uint8_t blockID = (uint8_t)b;
			int	datasize = 0;

			CRC_check(blockID, true);
			uint16_t crc = 0;

			switch (blockID) {
				case	0x01:	// DISK HEADER
					datasize = 0x38 + 2;
//		printf("DISK HEADER:%06X\n", bitstreampos);
					break;
				case	0x02:	// FILE AMOUNT
					datasize = 0x02 + 2;
//		printf("FILE AMOUNT:%06X\n", bitstreampos);
					break;
				case	0x03:	// FILE HEADER
					datasize = 0x10 + 2;
					blocksize = 0;
//		printf("FILE HEADER:%06X %3d\n", bitstreampos, fileindex);
					break;
				case	0x04:	// FILE DATA
					datasize = blocksize + 3;
//		printf("FILE DATA  :%06X %3d\n", bitstreampos, fileindex);
					break;

				case	0x05:	// pf[^
//		printf("f[^ :%06X %3d\n", bitstreampos, fileindex);
					goto	_CONVERT_EXIT;
					break;

				default:
					if ((blocknum < 2) || (fileindex < filenum)) {
						fprintf (stderr, "ERROR : BLOCK ID ܂B ID=%02X %6X\n", blockID, bitstreampos);
						return	1;
					}
					goto	_CONVERT_EXIT;
					break;
			}

			fdsoutput.Putc(blockID);
			outsize++;

			for (int i = 1; i < datasize; i++) {
				int data = ReadByte();
				if (data < 0) {
					if ((blocknum < 2) || (fileindex < filenum)) {
						fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
					}
					goto	_CONVERT_EXIT;
				}

				if (i < datasize-2) {
					fdsoutput.Putc(data);
					outsize++;
				}

				if (blockID == 0x02) {
					if (i == 1) {
						printf ("FILE NUM: %d\n", data);
						filenum = data;
					}
				}

				if (blockID == 0x03) {
					if (i == 13) {
						blocksize = data;
					}
					if (i == 14) {
						blocksize += data * 256;
					}
				}

				crc = CRC_check(data);
			}

			if (crc) {
				fprintf (stderr, "ERROR : CRC ܂Bindex:%d crc:%04X\n", fileindex, crc);
//				return	1;
			}
			if (blockID == 1) {
				blocknum++;
			}
			if (blockID == 2) {
				blocknum++;
			}
			if (blockID == 4) {
				fileindex++;
			}
			sync = false;
		}
	}

_CONVERT_EXIT:;

	while (outsize < 65500) {
		fdsoutput.Putc(0);
		outsize++;
	}

	printf ("ϊI܂\n");

	return	0;
}

