/*
̃\[XR[h́ABSDCZXłB

Copyright (c) 2014, Norix
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this 
    list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/*
XV
2014/ 4/ 2	Norix	Ń[X
2014/ 4/18	Norix	ϊf[^̏GAPTCY𒲐
2014/ 4/19	Norix	Жʂł*.DKBoĂ܂̂C
					3ʈȏ̏ꍇł2ʂ܂ŕϊ悤ɂ
*/

#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<stdint.h>

#include	<vector>
#include	<string>

#include	"fileio.h"
#include	"pathlib.h"

//const int header_gap = 0x2500 / 2;
const int header_gap = 0x2100 / 2;
const int data_gap = 250 / 2;

static
Pathlib	pathlib;

std::vector<uint8_t>	fdsbuffer;
std::vector<uint8_t>	rawbuffer;
std::vector<uint8_t>	bitstreambuffer;

uint8_t	bitstreamdata = 0;
uint8_t	bitstreamshift = 0;

void	WriteBits(uint8_t bit)
{
	if (bit)
		bitstreamdata |= (1 << bitstreamshift);
	else
		bitstreamdata &= ~(1 << bitstreamshift);

	if (++bitstreamshift >= 8) {
		bitstreambuffer.push_back(bitstreamdata);
		bitstreamdata = 0;
		bitstreamshift = 0;
	}
}

void	FlushBits()
{
	if (bitstreamshift != 0) {
		for ( ; bitstreamshift < 8; ) {
			bitstreamdata &= ~(1 << bitstreamshift);
			bitstreamshift++;
		}

		bitstreambuffer.push_back(bitstreamdata);
		bitstreamdata = 0;
		bitstreamshift = 0;
	}
}

void	MFM_encoder(uint8_t data)
{
	static	uint32_t	xorbits = 0x55550000;

	uint32_t	b = 0;
	for (int i = 0; i < 8; i++) {
		if (data & (1<<i)) {
			b |= (3 << (i*2));
		}
	}
	b ^= 0x5555;

	xorbits |= b << 16;

	for (int i = 0; i < 16; i++) {
		if (xorbits & (1<<15)) {
			WriteBits(0);
		} else {
			if (xorbits & (1<<16)) {
				WriteBits(1);
			} else {
				WriteBits(0);
			}
		}

		xorbits >>= 1;
	}
}

uint16_t	CRC_check(uint8_t data, bool initialize = false)
{
	static uint16_t crc = 0;

	if (initialize) {
		crc = 0x8408;
	}

	uint8_t	data_lsb = data;
	for (int i = 0; i < 8; i++) {
		uint8_t	exr = data_lsb & 1;
		data_lsb >>= 1;

		if (crc & 0x0001) {
			exr ^= 1;
		}

		crc >>= 1;
		if (exr) {
			crc ^= 0x8408;
		}
	}

	return	crc;
}

int	rawconvert(const char* fname, int fdspos)
{
	CFile	output;

	if (!output.Open(fname, "wb")) {
		fprintf (stderr, "ERROR : file open error.\n");
		return	1;
	}

	int	rawpos = 0;
	bool	done = false;
	int	filenum = 0;
	int	fileindex = -1;
	uint8_t	data;
	uint16_t	blocksize = 0;
	uint16_t	crc = 0;

	rawbuffer.clear();

	// wb_܂ł̃Mbv
	for (int i = 0; i < header_gap; i++) {
		rawbuffer.push_back(0);
		rawpos++;
	}

	while (!done) {
		if (fdspos >= fdsbuffer.size()) {
			if ((fileindex < 0) || (fileindex < filenum)) {
				fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
				return	1;
			}
			break;
		}

		switch (fdsbuffer[fdspos]) {
			// Block ID:1  *NINTENDO-HVC*
			case	0x01:
				rawbuffer.push_back(0x80);		// Start mark
				data = fdsbuffer[fdspos++];
				rawbuffer.push_back(data);
				CRC_check(data, true);
				for (int i = 1; i < 0x38; i++) {
					if (fdspos >= fdsbuffer.size()) {
						if ((fileindex < 0) || (fileindex < filenum)) {
							fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
							return	1;
						}
					}
					data = fdsbuffer[fdspos++];
					rawbuffer.push_back(data);
					crc = CRC_check(data);
				}
				rawbuffer.push_back((uint8_t)crc);
				rawbuffer.push_back((uint8_t)(crc>>8));

				// ̃f[^܂ł̃Mbv
				for (int i = 0; i < data_gap; i++) {
					rawbuffer.push_back(0);
				}
				break;

			// Block ID:2  File amount
			case	0x02:
				rawbuffer.push_back(0x80);		// Start mark
				data = fdsbuffer[fdspos++];
				rawbuffer.push_back(data);
				CRC_check(data, true);

				data = fdsbuffer[fdspos++];
				rawbuffer.push_back(data);
				crc = CRC_check(data);
				filenum = data;
				fileindex = 0;

				rawbuffer.push_back((uint8_t)crc);
				rawbuffer.push_back((uint8_t)(crc>>8));

				// ̃f[^܂ł̃Mbv
				for (int i = 0; i < data_gap; i++) {
					rawbuffer.push_back(0);
				}
				break;

			// Block ID:3  File header
			case	0x03:
				rawbuffer.push_back(0x80);		// Start mark
				data = fdsbuffer[fdspos++];
				rawbuffer.push_back(data);
				CRC_check(data, true);
				for (int i = 1; i < 16; i++) {
					if (fdspos >= fdsbuffer.size()) {
						if ((fileindex < 0) || (fileindex < filenum)) {
							fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
							return	1;
						}
					}
					data = fdsbuffer[fdspos++];
					rawbuffer.push_back(data);
					if (i == 0x0d) blocksize = data;
					if (i == 0x0e) blocksize |= (uint16_t)data<<8;
					crc = CRC_check(data);
				}
				rawbuffer.push_back((uint8_t)crc);
				rawbuffer.push_back((uint8_t)(crc>>8));

				// ̃f[^܂ł̃Mbv
				for (int i = 0; i < data_gap; i++) {
					rawbuffer.push_back(0);
				}
				break;

			// Block ID:4  File data
			case	0x04:
				rawbuffer.push_back(0x80);		// Start mark
				data = fdsbuffer[fdspos++];
				rawbuffer.push_back(data);
				CRC_check(data, true);
				for (int i = 1; i < blocksize + 1; i++) {
					if (fdspos >= fdsbuffer.size()) {
						if ((fileindex < 0) || (fileindex < filenum)) {
							fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
							return	1;
						}
					}
					data = fdsbuffer[fdspos++];
					rawbuffer.push_back(data);
					crc = CRC_check(data);
				}
				rawbuffer.push_back((uint8_t)crc);
				rawbuffer.push_back((uint8_t)(crc>>8));

				// ̃f[^܂ł̃Mbv
				for (int i = 0; i < data_gap; i++) {
					rawbuffer.push_back(0);
				}

				fileindex++;
				break;

			default:
				if ((fileindex < 0) || (fileindex < filenum)) {
					fprintf(stderr, "ERROR: Unknown ID : %02X\n", fdsbuffer[fdspos]);
					return	1;
				}
				done = true;
				break;
		}
	}

	// size check
	if (rawbuffer.size() > 1024*70) {
		fprintf (stderr, "ERROR : raw file size is over.\n");
		return	1;
	}

	// padding data
	while (rawbuffer.size() < 1024*70) {
		rawbuffer.push_back(0);
	}

	// Encode MFM raw binary
	bitstreambuffer.clear();
	for (int i = 0; i < rawbuffer.size(); i++) {
		MFM_encoder(rawbuffer[i]);
	}
	FlushBits();

	if (!output.Write(&bitstreambuffer[0], bitstreambuffer.size())) {
		fprintf (stderr, "ERROR : file write error.\n");
		return	1;
	}

	return	0;
}

int	main(int argc, char* argv[])
{
	if (argc < 2) {
		printf ("FDS image encoder (C)Norix,2014\n" );
		printf (" Usage : FDSencoder filename\n");
		return	0;
	}

	CFile	file;

	if (!file.Open(argv[1], "rb")) {
		fprintf (stderr, "ERROR : file not found. [%s]\n", argv[1]);
		return	1;
	}

	fdsbuffer.resize(file.GetSize());

	if (!file.Read(&fdsbuffer[0], file.GetSize())) {
		fprintf (stderr, "ERROR : file read error.\n");
		return	1;
	}

	file.Close();

	if (fdsbuffer.size() < 0xFFEC) {
		fprintf (stderr, "ERROR : FDS`̃t@CTCY܂\n");
		return	1;
	}

	if ((fdsbuffer[0] != 'F') || (fdsbuffer[1] != 'D') || (fdsbuffer[2] != 'S') || (fdsbuffer[3] != 0x1A)) {
		fprintf (stderr, "ERROR : FDS`ł͂܂\n");
		return	1;
	}

	if (!fdsbuffer[4]) {
		fprintf (stderr, "ERROR : FDS̖ʐ܂\n");
		return	1;
	}
	if (fdsbuffer[4] > 2) {
		fprintf (stderr, "Warning : FDS̖ʐ2ʂ܂łϊ܂\n");
	}

	printf ("FDS disk number : %d\n", (int)fdsbuffer[4]);

	std::string fname = Pathlib::SplitFilename (argv[1]);

	const char* exts[] = { ".DKA", ".DKB" };

	int	fdspos = 16;
	int	numdisk = fdsbuffer[4];
	if (numdisk > 2)
		numdisk = 2;
	for (int i = 0; i < numdisk; i++) {
		char	temp[1024];
		wsprintf (temp, "%s%s", fname.c_str(), exts[i & 1]);
		printf ("Create file: %s\n", temp);
		if (rawconvert (temp, fdspos)) {
			fprintf (stderr, "ERROR : ϊŃG[܂\n");
			return	1;
		}
		fdspos += 0xFFDC;
	}

	printf ("ϊI܂B\n");

	return	0;
}
