/*
̃\[XR[h́ABSDCZXłB

Copyright (c) 2014, Norix
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this 
    list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/*
XV
2014/ 4/ 2	Norix	Ń[X
2014/ 4/ 5	Norix	ID MARKC/GAP/SYNC𒲐
					t@C̈͑Sĕ\悤ɂ
*/

#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<stdint.h>

#include	<vector>
#include	<string>

#include	"fileio.h"
#include	"pathlib.h"

#pragma	pack(1)
typedef	struct BLOCKINFO {
	uint8_t	id;
	uint8_t	flag;
	uint8_t	size[2];
} BLOCKINFO;

typedef	struct INFOBLOCK {
	uint8_t	attribute;
	uint8_t	filename[17];	// MZ-1500$0DŏI镶AMSX QDFATl8.3`
	uint8_t	lock;
	uint8_t	secret;
	uint8_t	filesize[2];
	uint8_t	loadaddr[2];
	uint8_t	execaddr[2];
	uint8_t	comment[38];
} INFOBLOCK;

typedef	struct MZTINFO {
	uint8_t	attribute;
	uint8_t	filename[17];	// 18
	uint8_t	filesize[2];	// 20
	uint8_t	loadaddr[2];	// 22
	uint8_t	execaddr[2];	// 24
	uint8_t	reserved[38];
	uint8_t	lock;			// 62
	uint8_t	secret;			// 63
	uint8_t	patch[64];
} MZTINFO;
#pragma	pack()

#if	0
// MSX type
const int header_gap = 5480;
const int data_gap1 = 3070;
const int data_gap2 = 285;

const int sync1 = 12;
const int sync2 = 8;

const uint8_t	idmark = 0xA5;
#else
// MZ-1500 type
const int header_gap = 4785;
const int data_gap1 = 2755;
const int data_gap2 = 256;

const int sync1 = 10;
const int sync2 = 6;

const uint8_t	idmark = 0xA5;
#endif

static
Pathlib	pathlib;

std::vector<uint8_t>	bitstreambuffer;

uint8_t	bitstreamdata = 0;
uint8_t	bitstreamshift = 0;

void	WriteBits(uint8_t bit)
{
	if (bit)
		bitstreamdata |= (1 << bitstreamshift);
	else
		bitstreamdata &= ~(1 << bitstreamshift);

	if (++bitstreamshift >= 8) {
		bitstreambuffer.push_back(bitstreamdata);
		bitstreamdata = 0;
		bitstreamshift = 0;
	}
}

void	FlushBits()
{
	if (bitstreamshift != 0) {
		for ( ; bitstreamshift < 8; ) {
			bitstreamdata &= ~(1 << bitstreamshift);
			bitstreamshift++;
		}

		bitstreambuffer.push_back(bitstreamdata);
		bitstreamdata = 0;
		bitstreamshift = 0;
	}
}

void	MFM_encoder(uint8_t data)
{
	static	uint32_t	xorbits = 0x55550000;

	uint32_t	b = 0;
	for (int i = 0; i < 8; i++) {
		if (data & (1<<i)) {
			b |= (3 << (i*2));
		}
	}
	b ^= 0x5555;

	xorbits |= b << 16;

	for (int i = 0; i < 16; i++) {
		if (xorbits & (1<<15)) {
			WriteBits(0);
		} else {
			if (xorbits & (1<<16)) {
				WriteBits(1);
			} else {
				WriteBits(0);
			}
		}

		xorbits >>= 1;
	}
}

// CRCvZ CRC-16 X^16+X^15+X^2+1 (GR[hp ] E)
uint16_t	CRC_check(uint8_t data, bool initialize = false)
{
	static uint16_t crc = 0;

	if (initialize) {
		crc = 0x0000;
	}

	uint8_t data_lsb = data;
	for (int i = 0; i < 8; i++) {
		uint8_t exr = data_lsb & 1;
		data_lsb >>= 1;

		if (crc & 1) {
			exr ^= 1;
		}

		crc >>= 1;
		if (exr) {
			crc ^= 0xA001;
		}
	}

	return	crc;
}

#define	QDFOUTPUT	0		// eXgp

int	main(int argc, char* argv[])
{
	if (argc < 2) {
		printf ("MZT image encoder (C)Norix, 2014\n" );
		printf (" Usage : MZTencoder mztfile\n");
		return	0;
	}

	CFile	file;

	if (!file.Open(argv[1], "rb")) {
		fprintf (stderr, "ERROR : file not found. [%s]\n", argv[1]);
		return	1;
	}

	std::vector<uint8_t>	mztbuffer;
	std::vector<uint8_t>	rawbuffer;

	if (file.GetSize() <= sizeof(MZTINFO)) {
		fprintf (stderr, "ERROR : file size error.\n");
		return	1;
	}

	mztbuffer.resize(file.GetSize());

	if (!file.Read(&mztbuffer[0], file.GetSize())) {
		fprintf (stderr, "ERROR : file read error.\n");
		return	1;
	}

	file.Close();

	std::string fname = Pathlib::SplitFilename (argv[1]);
#if	QDFOUTPUT
	fname = fname + ".QDF";
#else
	fname = fname + ".QDK";
#endif

	CFile	output;
	if (!output.Open(fname.c_str(), "wb")) {
		fprintf (stderr, "ERROR : file open error.\n");
		return	1;
	}

#if	QDFOUTPUT
	// for QDF
	const uint8_t	imgheader[16] = {
		'-', 'Q', 'D', ' ', 'f', 'o', 'r', 'm', 'a', 't', '-', 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	};

	if (!output.Write((void*)imgheader, sizeof(imgheader))) {
		fprintf (stderr, "ERROR : file write error.\n");
		return	1;
	}
#endif

	int	mztsize = mztbuffer.size();

	int	mztpos = 0;
	int	rawpos = 0;
	uint16_t	crc;
	int		mztblocknum;
	int		gapsize = data_gap1;
	MZTINFO		mztinfo;

	// ȈՓIɃubNvZ
	mztblocknum = 0;
	while (true) {
		// c肪INFOf[^ȉȂ΃[vI
		if ((mztpos + sizeof(MZTINFO)) > mztsize) {
			break;
		}

		memcpy (&mztinfo, &mztbuffer[mztpos], sizeof(MZTINFO));
		mztpos += sizeof(MZTINFO);
		mztpos += (uint16_t)mztinfo.filesize[0] + (uint16_t)mztinfo.filesize[1] * 256;
		mztblocknum += 2;
	}

	// ubNȊO̓_(ȈՓIɑi[_r)
	// I+D+DȂǁAf[^ubN݂̂̓TCY킩Ȃߐϊo܂
	// ɕϊłƂĂ炭f[^ł͂܂
	if (!mztblocknum || (mztblocknum & 1) || (mztblocknum < 2) || (mztblocknum > 255)) {
		fprintf (stderr, "ERROR : MZT block number error. [%d]\n", mztblocknum);
		return	1;
	}

	printf ("MZT blocks: %d\n", mztblocknum);

	// QDfBXNC[Wo͊Jn
	rawbuffer.clear();

	// wb_܂ł̃Mbv
	for (int i = 0; i < header_gap; i++) {
		rawbuffer.push_back(0);
		rawpos++;
	}

	// ubNTCYo
	for (int i = 0; i < sync1; i++) {
		rawbuffer.push_back (0x16);
		rawpos++;
	}
	rawbuffer.push_back (idmark);
	CRC_check(idmark, true);
	rawbuffer.push_back ((uint8_t)mztblocknum);
	crc = CRC_check((uint8_t)mztblocknum);
	rawbuffer.push_back((uint8_t)crc);
	rawbuffer.push_back((uint8_t)(crc>>8));
	for (int i = 0; i < sync2; i++) {
		rawbuffer.push_back (0x16);
		rawpos++;
	}

	mztpos = 0;
	while (true) {
		// c肪INFOf[^ȉȂ΃[vI
		if ((mztpos + sizeof(MZTINFO)) > mztsize) {
			printf ("End of data.\n");
			break;
		}

		// Gapo
		for (int i = 0; i < gapsize; i++) {
			rawbuffer.push_back(0);
			rawpos++;
		}
		gapsize = data_gap2;

		memcpy (&mztinfo, &mztbuffer[mztpos], sizeof(MZTINFO));
		mztpos += sizeof(MZTINFO);

		// Synco
		for (int i = 0; i < sync1; i++) {
			rawbuffer.push_back (0x16);
			rawpos++;
		}

		// Infoo
		INFOBLOCK	info = { mztinfo.attribute };
		memcpy (info.filename, mztinfo.filename, sizeof(info.filename));

		info.filesize[0] = mztinfo.filesize[0];
		info.filesize[1] = mztinfo.filesize[1];
                           
		info.loadaddr[0] = mztinfo.loadaddr[0];
		info.loadaddr[1] = mztinfo.loadaddr[1];
                           
		info.execaddr[0] = mztinfo.execaddr[0];
		info.execaddr[1] = mztinfo.execaddr[1];
                           
		info.lock = mztinfo.lock;
		info.secret = mztinfo.secret;

		{
			char	fname[256];
			char*	fp = fname;

			for (int i = 0; i < sizeof(info.filename); i++) {
				if (info.filename[i] == '%') {
					*fp++ = '%';	// percent encoding
					*fp++ = '%';
				} else
				if (info.filename[i] >= 0x20) {
					*fp++ = info.filename[i];
				} else {
					uint8_t	nibble;
					*fp++ = '%';	// percent encoding
					nibble = (info.filename[i] >> 4);
					nibble = (nibble < 10) ? '0'+nibble : 'A'+nibble-10;
					*fp++ = nibble;
					nibble = info.filename[i] & 0x0F;
					nibble = (nibble < 10) ? '0'+nibble : 'A'+nibble-10;
					*fp++ = nibble;
				}
			}
			*fp++ = '\0';

			printf ("FILE INFORMATION\n");
			printf ("NAME:%s\n", fname);
			printf ("ATTR:%02X\n", info.attribute);
			printf ("SIZE:%04X\n", info.filesize[1] * 256 + info.filesize[0]);
			printf ("LOAD:%04X\n", info.loadaddr[1] * 256 + info.loadaddr[0]);
			printf ("EXEC:%04X\n", info.execaddr[1] * 256 + info.execaddr[0]);
			printf ("\n");
		}

		// DATA-FILEʕ
		// ID
		rawbuffer.push_back (idmark);
		CRC_check(idmark, true);
		// FLAG
		rawbuffer.push_back (0x00);
		crc = CRC_check(0x00);
		// SIZE
		int	infosize = sizeof(INFOBLOCK);
		rawbuffer.push_back ((uint8_t)infosize);
		rawbuffer.push_back ((uint8_t)(infosize>>8));
		CRC_check((uint8_t)infosize);
		crc = CRC_check((uint8_t)(infosize>>8));

		// DATA-FILE
		uint8_t*	infop = (uint8_t*)&info;
		for (int i = 0; i < sizeof(INFOBLOCK); i++) {
			rawbuffer.push_back (infop[i]);
			crc = CRC_check(infop[i]);
			rawpos++;
		}
		// CRCo
		rawbuffer.push_back ((uint8_t)crc);
		rawbuffer.push_back ((uint8_t)(crc>>8));
		CRC_check((uint8_t)crc);
		crc = CRC_check((uint8_t)(crc>>8));
		// ꉞCRCmF
		if (crc) {
			// crc error
			fprintf (stderr, "ERROR : crc error.[%04X]\n", crc);

#if	QDFOUTPUT
	// Write QDF
	if (!output.Write(&rawbuffer[0], rawbuffer.size())) {
		fprintf (stderr, "ERROR : file write error.\n");
		return	1;
	}
#endif
			return	1;
		}

		// Synco
		for (int i = 0; i < sync2; i++) {
			rawbuffer.push_back (0x16);
			rawpos++;
		}

		// f[^{
		// Gapo
		for (int i = 0; i < gapsize; i++) {
			rawbuffer.push_back(0);
			rawpos++;
		}

		// Synco
		for (int i = 0; i < sync1; i++) {
			rawbuffer.push_back (0x16);
			rawpos++;
		}

		// DATA-FILEʕ
		// ID
		rawbuffer.push_back (idmark);
		CRC_check(idmark, true);
		// FLAG
		rawbuffer.push_back (0x05);
		crc = CRC_check(0x05);
		// SIZE
		rawbuffer.push_back (info.filesize[0]);
		rawbuffer.push_back (info.filesize[1]);
		CRC_check(info.filesize[0]);
		crc = CRC_check(info.filesize[1]);

		// f[^{
		int	datasize = (int)info.filesize[0] + (int)info.filesize[1] * 256;
		for (int i = 0; i < datasize; i++) {
			rawbuffer.push_back (mztbuffer[mztpos]);
			crc = CRC_check(mztbuffer[mztpos]);
			rawpos++;
			mztpos++;
		}
		// CRCo
		rawbuffer.push_back ((uint8_t)crc);
		rawbuffer.push_back ((uint8_t)(crc>>8));
		CRC_check((uint8_t)crc);	// ͖߂Ȃ
		crc = CRC_check((uint8_t)(crc>>8));
		// ꉞCRCmF
		if (crc) {
			// crc error
			fprintf (stderr, "ERROR : crc error.[%04X]\n", crc);

#if	QDFOUTPUT
	// Write QDF
	if (!output.Write(&rawbuffer[0], rawbuffer.size())) {
		fprintf (stderr, "ERROR : file write error.\n");
		return	1;
	}
#endif
			return	1;
		}

		// Synco
		for (int i = 0; i < sync2; i++) {
			rawbuffer.push_back (0x16);
			rawpos++;
		}
	}

#if	QDFOUTPUT
	// size check
	if (rawbuffer.size() > 1024*80+16) {
		fprintf (stderr, "ERROR : raw file size is over.\n");
		return	1;
	}

	// padding data
	while (rawbuffer.size() < 1024*80+16) {
		rawbuffer.push_back(0);
	}

	// Write QDF
	if (!output.Write(&rawbuffer[0], rawbuffer.size())) {
		fprintf (stderr, "ERROR : file write error.\n");
		return	1;
	}
#else
	// size check
	if (rawbuffer.size() > 1024*80) {
		fprintf (stderr, "ERROR : raw file size is over.\n");
		return	1;
	}

	// padding data
	while (rawbuffer.size() < 1024*80) {
		rawbuffer.push_back(0);
	}

	// Encode MFM raw binary
	bitstreambuffer.clear();
	for (int i = 0; i < rawbuffer.size(); i++) {
		MFM_encoder(rawbuffer[i]);
	}
	FlushBits();

	if (!output.Write(&bitstreambuffer[0], bitstreambuffer.size())) {
		fprintf (stderr, "ERROR : file write error.\n");
		return	1;
	}
#endif

	output.Close();

	printf ("Complete.\n");

	return	0;
}

