/*
̃\[XR[h́ABSDCZXłB

Copyright (c) 2014, Norix
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this 
    list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include "pathlib.h"

#pragma comment(lib, "shlwapi.lib")

Pathlib::Pathlib()
{
	::CoInitialize( NULL );
}

Pathlib::~Pathlib()
{
	::CoUninitialize();
}

std::string	Pathlib::SplitPath( const char* path )
{
	char	temp[_MAX_PATH];
	::strcpy( temp, path );
	::PathRemoveFileSpec( temp );
	return	std::string(temp);
}

std::string	Pathlib::SplitFile( const char* path )
{
	return	std::string(::PathFindFileName(path));
}

std::string	Pathlib::SplitFilename( const char* path )
{
	char	temp[_MAX_PATH];
	::strcpy( temp, SplitFile( path ).c_str() );
	::PathRemoveExtension( temp );

	return	std::string(temp);
}

std::string	Pathlib::CreatePath( const char* base, const char* path )
{
	char	temp[_MAX_PATH];
	if( (::strncmp( path, "..\\", 3 ) == 0) || (::strncmp( path, ".\\", 2 ) == 0) ) {
		char	tmp[_MAX_PATH];
		::strcpy( tmp, base );
		::PathAppend( tmp, path );
		::PathCanonicalize( temp, tmp );
	} else {
		::strcpy( temp, path );
	}

	return	std::string(temp);
}

std::string	Pathlib::CreateFilePath( const char* base, const char* path, const char* name )
{
	std::string	filepath;
	filepath = CreatePath( base, path );

	char	temp[_MAX_PATH];
	::strcpy( temp, filepath.c_str() );
	::PathAppend( temp, name );

	return	std::string(temp);
}

std::string	Pathlib::CreateFilePathExt( const char* base, const char* path, const char* name, const char* ext )
{
	std::string	filepath;
	filepath = CreatePath( base, path );

	char	temp[_MAX_PATH];
	::strcpy( temp, filepath.c_str() );
	::PathAppend( temp, name );
	::PathAddExtension( temp, ext );

	return	std::string(temp);
}


INT CALLBACK	Pathlib::BffCallback( HWND hWnd, UINT uMsg, LPARAM /*lParam*/, WPARAM wParam )
{
	if( uMsg == BFFM_INITIALIZED && wParam ) {
		::SendMessage( hWnd, BFFM_SETSELECTION, TRUE, wParam );
	}
	return	TRUE;
}

bool	Pathlib::SelectFolder( HWND hWnd, LPCSTR lpszTitle, LPSTR lpszFolder )
{
	BROWSEINFO	bi;
	LPITEMIDLIST	pidl;

	::ZeroMemory( &bi, sizeof(bi) );
	bi.hwndOwner = hWnd;
	bi.lpszTitle = lpszTitle;
	bi.ulFlags = BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE;

	bi.lpfn = (BFFCALLBACK)BffCallback;
	bi.lParam = (LPARAM)lpszFolder;

	::PathRemoveBackslash( lpszFolder );

	if( (pidl = ::SHBrowseForFolder( &bi )) ) {
		::SHGetPathFromIDList( pidl, lpszFolder );
		::PathAddBackslash( lpszFolder );

		IMalloc* pMalloc;
		::SHGetMalloc( &pMalloc );
		if( pMalloc ) {
			pMalloc->Free( pidl );
			pMalloc->Release();
		}
		return	true;
	}

	return	false;
}


