/*
̃\[XR[h́ABSDCZXłB

Copyright (c) 2014, Norix
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this 
    list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#ifndef	__PATHLIB_INCLUDED__
#define	__PATHLIB_INCLUDED__

#include <windows.h>
#include <shlobj.h>
#include <shlwapi.h>
#include <string>

class	Pathlib
{
public:
	Pathlib();
	virtual	~Pathlib();

	static	std::string	SplitPath( const char* path );

	static	std::string	SplitFile( const char* path );
	static	std::string	SplitFilename( const char* path );

	static	std::string	CreatePath( const char* base, const char* path );
	static	std::string	CreateFilePath( const char* base, const char* path, const char* name );
	static	std::string	CreateFilePathExt( const char* base, const char* path, const char* name, const char* ext );

	static	bool	SelectFolder( HWND hWnd, LPCSTR lpszTitle, LPSTR lpszFolder );

protected:
	static	INT CALLBACK	BffCallback( HWND hWnd, UINT uMsg, LPARAM /*lParam*/, WPARAM wParam );

private:
};

#endif	// !__PATHLIB_INCLUDED__
