/*
̃\[XR[h́ABSDCZXłB

Copyright (c) 2014, Norix
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this 
    list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#ifndef	__FILEIO_INCLUDED__
#define	__FILEIO_INCLUDED__

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string>

class	CFile
{
public:
	CFile() : m_fp(NULL), m_size(0), m_write(false)
	{
	}
	virtual	~CFile()
	{
		Close();
	}

	bool	Open( const char* fname, const char* mode )
	{
		m_write = true;
		if( ::strchr( mode, 'r' ) != NULL )
			m_write = false;

		if( !(m_fp = ::fopen( fname, mode )) )
			return	false;

		m_size = 0;
		if( !m_write ) {
			long	savepos = ::ftell( m_fp );
			Seek( 0, SEEK_END );
			m_size = ::ftell( m_fp );
			Seek( savepos, SEEK_SET );
		}

		return	true;
	}
	bool	Open( const std::string& fname, const char* mode )
	{
		return	Open( fname.c_str(), mode );
	}

	void	Close()
	{
		if( m_fp ) {
			::fclose( m_fp );
			m_fp = NULL;
		}
	}

	bool	IsOpened() const
	{
		if (m_fp) {
			return	true;
		}

		return	false;
	}

	size_t	GetSize() const
	{
		return	m_size;
	}

	bool	Seek( long offset, int origin )
	{
		assert( m_fp );
		return	::fseek( m_fp, offset, origin ) ? false : true;
	}

	bool	Read( void* buffer, size_t size )
	{
		assert( m_fp );
		return	(::fread( buffer, size, 1, m_fp ) != 1) ? false : true;
	}

	bool	Write( void* buffer, size_t size )
	{
		assert( m_fp );

		if (::fwrite( buffer, size, 1, m_fp ) != 1)
			return	false;

		m_size += size;
		return	true;
	}

	int	Getc()
	{
		assert( m_fp );
		return	::fgetc( m_fp );
	}
	int	Putc( int data )
	{
		assert( m_fp );
		int	ret = ::fputc( data, m_fp );
		m_size += sizeof(char);
		return	ret;
	}

	bool	Gets( char* buffer, int size )
	{
		assert( m_fp );
		return	(!::fgets( buffer, size, m_fp )) ? false : true;
	}
	bool	Puts( char* buffer )
	{
		assert( m_fp );
		if (::fputs( buffer, m_fp ) == EOF)
			return	false;

		m_size += ::strlen (buffer);
		return	true;
	}

protected:
	FILE*	m_fp;
	size_t	m_size;
	bool	m_write;

private:
};

#endif	// !__FILEIO_INCLUDED__
