/*
̃\[XR[h́ABSDCZXłB

Copyright (c) 2014, Norix
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this 
    list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/*
XV
2014/ 4/ 2	Norix	Ń[X
2014/ 4/ 5	Norix	ID MARKCiMZ$A5̂悤łj
					t@C̈͑Sĕ\悤ɂ
*/

#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<stdint.h>

#include	<string>
#include	<vector>

#include	"fileio.h"
#include	"pathlib.h"

#pragma	pack(1)
typedef	struct BLOCKINFO {
	uint8_t	id;
	uint8_t	flag;
	uint8_t	size[2];
} BLOCKINFO;

typedef	struct INFOBLOCK {
	uint8_t	attribute;
	uint8_t	filename[17];	// MZ-1500$0DŏI镶AMSX QDFATl8.3`
	uint8_t	lock;
	uint8_t	secret;
	uint8_t	filesize[2];
	uint8_t	loadaddr[2];
	uint8_t	execaddr[2];
	uint8_t	comment[38];
} INFOBLOCK;

typedef	struct MZTINFO {
	uint8_t	attribute;
	uint8_t	filename[17];	// 18
	uint8_t	filesize[2];	// 20
	uint8_t	loadaddr[2];	// 22
	uint8_t	execaddr[2];	// 24
	uint8_t	reserved[38];
	uint8_t	lock;			// 62
	uint8_t	secret;			// 63
	uint8_t	patch[64];
} MZTINFO;
#pragma	pack()

static
Pathlib	pathlib;

std::vector<uint8_t>	bitstreambuffer;

int	bitstreampos = 0;
uint8_t	bitstreammask = 1;

uint8_t	syncbyte;

int	ReadBits(int count)
{
	if (bitstreampos >= bitstreambuffer.size())
		return	-1;

	int	bit = 0;
	int	bit2 = 1;

	for (int i = 0; i < count; i++)
	{
		if (bitstreambuffer[bitstreampos] & bitstreammask)
		{
			bit |= bit2;
		}

		bit2 <<= 1;

		bitstreammask <<= 1;
		if (!bitstreammask)
		{
			bitstreammask = 1;
			bitstreampos++;
		}
	}

	return	bit;
}

// Gapf[^ȊOɂȂ܂ő
int	SearchGap()
{
	bool found = false;

	while (true) {
		int bit = ReadBits(8);
		if (bit < 0) {
			return	-1;
		}

		if (bit == 0x55) {
			found = true;
			continue;
		}

		if (bit == 0xAA) {
			ReadBits(1);	// bit␳
			found = true;
			continue;
		}

		if (found) {
			if (bit != 0x55) {
				break;
			}
		}
	}

	return	0;
}

// Syncf[^ɂȂ܂ő
int	FindSync()
{
	for (int i = 0; i < 16; i++) {
		syncbyte >>= 1;

		int bit = ReadBits(2);
		if (bit < 0) {
			return	-1;
		}

		if (bit & 2) {
			syncbyte |= 0x80;
		}

		if (syncbyte == 0x16) {
			return	0x16;
		}
	}

	return	0x00;
}

// 1oCg擾
int	ReadByte()
{
	uint8_t	data = 0;

	for (int i = 0; i < 8; i++)
	{
		int bit = ReadBits(2);
		if (bit < 0)
			return	-1;

		if (bit & 2)
		{
			data |= (1 << i);
		}
	}

	return	data;
}

// CRCvZ CRC-16 X^16+X^15+X^2+1
uint16_t	CRC_check(uint8_t data, bool initialize = false)
{
	static uint16_t crc = 0;

	if (initialize) {
		crc = 0x0000;
	}

	uint8_t data_lsb = data;
	for (int i = 0; i < 8; i++) {
		uint8_t exr = data_lsb & 1;
		data_lsb >>= 1;

		if (crc & 0x8000) {
			exr ^= 1;
		}

		crc <<= 1;
		if (exr) {
			crc ^= 0x8005;
		}
	}

	return	crc;
}

int	main(int argc, char* argv[])
{
bool	dumpmode = false;
bool	mztmode = false;
bool	splitdumpmode = false;
char*	filename = NULL;

	if( argc < 2 ) {
		printf ("QD image decoder (C)Norix, 2014\n" );
		printf ("Usage : QDdecoder [option] imagefile\n" );
		printf (" Options\n" );
		printf (" -d dump file\n");
		printf (" -s split dump mode\n");
		printf (" -m dump mzt file\n");
		return	0;
	}

	// IvV
	for(int i = 1; i < argc; i++ ) {
		if( argv[i][0] == '-' || argv[i][0] == '/' ) {
			switch( toupper(argv[i][1]) ) {
				case	'D':
					dumpmode = true;
					break;
				case	'M':
					mztmode = true;
					break;
				case	'S':
					splitdumpmode = true;
					break;
			}
		} else
		if (!filename) {
			filename = argv[i];
		}
	}

	if (!filename) {
		fprintf (stderr, "ERROR: filename ܂\n" );
		return	0;
	}

	{
		CFile	file;

		if (!file.Open(filename, "rb")) {
			fprintf (stderr, "ERROR : file not found. [%s]\n", argv[1]);
			return	0;
		}

		bitstreambuffer.resize(file.GetSize());

		if (!file.Read(&bitstreambuffer[0], file.GetSize())) {
			fprintf (stderr, "ERROR : file read error.\n");
			return	0;
		}
	}

	CFile	outfile;
	CFile	splitfile;
	CFile	mztfile;

	if (dumpmode) {
		std::string	name = Pathlib::SplitFilename (filename);
		std::string	outname = name + ".qdf";

		if (!outfile.Open(outname.c_str(), "wb")) {
			fprintf (stderr, "ERROR : file open error.\n");
			return	1;
		}

		printf ("dump file:%s\n", outname.c_str());

					//0123456789ABCDEF
		outfile.Puts("-QD format-");
		outfile.Putc(0xFF);
		outfile.Putc(0xFF);
		outfile.Putc(0xFF);
		outfile.Putc(0xFF);
		outfile.Putc(0xFF);
	}

	if (mztmode) {
		std::string	name = Pathlib::SplitFilename (filename);
		std::string	mztname = name + ".mzt";

		if (!mztfile.Open(mztname.c_str(), "wb")) {
			fprintf (stderr, "ERROR : file open error.\n");
			return	1;
		}

		printf ("MZT file:%s\n", mztname.c_str());
	}

	if (!dumpmode && !splitdumpmode && !mztmode) {
		printf ("t@Ĉݕ\܂...\n");
	} else {
		printf ("t@Cϊ܂...\n");
	}

	// skip garbage data
	bitstreampos = 0x1800;
	bitstreammask = 1;

	bool	blockstart = false;
	bool	blockfile = true;
	bool	eoffile = false;
	uint8_t	idcode = 0;
	int	blockindex = 0;
	int	blocksize = 0;
	int	blocknum = 0;
	int	blocknumindex = -1;
	int	lastgappos = 0;

	BLOCKINFO	blockinfo;
	uint8_t*	blockinfoptr = (uint8_t*)&blockinfo;

	INFOBLOCK	info;
	uint8_t*	infoptr = (uint8_t*)&info;

	enum {
		DECODE_SEARCHSENDBREAK = 0,
		DECODE_SEARCHSYNC,
		DECODE_SEARCHSYNCEXIT,
		DECODE_BLOCKSTART,
		DECODE_BLOCKFILE,
		DECODE_DATAHEADER,
		DECODE_DATAFILE
	};

	int	state = DECODE_SEARCHSENDBREAK;

	while (1) {
		int	ret;
		uint16_t	crc = 0;

		switch (state) {
			// Gapf[^ȊOɂȂ鏊܂ŒT
			case	DECODE_SEARCHSENDBREAK:
				if (SearchGap() < 0) {
					if (blocknumindex < 0) {
						fprintf (stderr, "ERROR : Gapf[^܂B\n");
						return	1;
					} else {
						if (blocknumindex < blocknum) {
							fprintf (stderr, "ERROR : Gapf[^܂B\n");
							return	1;
						}
						goto	_CONVERT_DONE;
					}
				}
				state = DECODE_SEARCHSYNC;

				// GapŖ߂
				if (outfile.IsOpened()) {
					for (int i = lastgappos; i < bitstreampos; i+=2) {
						// Gap
						outfile.Putc(0x00);
					}
					lastgappos = bitstreampos;
				}
				break;

			// Gap->SyncɂȂ܂ŒT
			case	DECODE_SEARCHSYNC:
				ret = FindSync();
				if (ret < 0) {
					if (blocknumindex < blocknum) {
						fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
						return	1;
					}
					goto	_CONVERT_DONE;
				}

				if (ret == 0x16) {
//					printf ("Found sync (%06X)\n", bitstreampos);
					state = DECODE_BLOCKSTART;
				}
				break;

			// Sync甲܂ŒT
			case	DECODE_SEARCHSYNCEXIT:
				ret = ReadByte();
				if (ret < 0) {
					if (blocknumindex < blocknum) {
						fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
						return	1;
					}
					goto	_CONVERT_DONE;
				}

				if (ret != 0x16) {
					//printf ("Found sync exit (%06X)\n", bitstreampos);
					state = DECODE_SEARCHSENDBREAK;

					// Sync̓rbgꂪ̂ŏǂ
					for (int i = 0; i < 32; i++) {
						ret = ReadByte();
						if (ret < 0) {
							if (blocknumindex < blocknum) {
								fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
								return	1;
							}
							goto	_CONVERT_DONE;
						}
						// Gap
						if (outfile.IsOpened()) {
							outfile.Putc(0x00);
							lastgappos = bitstreampos;
						}
					}
				} else {
					// Sync
					if (outfile.IsOpened()) {
						outfile.Putc(0x16);
						lastgappos = bitstreampos;
					}
				}
				break;

			// ubNJnf[^܂ŒT
			case	DECODE_BLOCKSTART:
				// Find Block ID
				ret = ReadByte();
				if (ret < 0) {
					if (blocknumindex < blocknum) {
						fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
						return	1;
					}
					goto	_CONVERT_DONE;
				}
				if (ret != 0x16) {
					if ((ret != 0x01) && (ret != 0xA5)) {
						if (blocknumindex < blocknum) {
							fprintf (stderr, "ERROR : ubNIDُł(%02X)\n", ret);
							return	1;
						}
						goto	_CONVERT_DONE;
					}

					// ID MARK MSX QDMZ-1500炵 2014/4/5
					if (!idcode) {
						idcode = ret;
/*						if (idcode == 0x01) {
							printf ("QD MODE: MZ-1500\n\n");
						} else
						if (idcode == 0xA5) {
							printf ("QD MODE: MSX\n\n");
						}
*/
					} else
					if (idcode != ret) {
						fprintf (stderr, "ERROR : ubNIDُł(%02X)\n", ret);
						return	1;
					}

					if (outfile.IsOpened()) {
						outfile.Putc(idcode);
					}

					if (blockfile) {
						crc = CRC_check (ret, true);
						state = DECODE_BLOCKFILE;
						blocksize = 4-1;
						blockindex = 1;
					} else {
						crc = CRC_check (ret, true);
						state = DECODE_DATAHEADER;
						blocksize = 4-1;
						blockstart = false;
						blockindex = 1;
						blockinfoptr[0] = ret;
					}
				} else {
					if (outfile.IsOpened()) {
						// Sync
						outfile.Putc(0x16);
						lastgappos = bitstreampos;
					}
				}
				break;

			// ubNt@C
			case	DECODE_BLOCKFILE:
				ret = ReadByte();
				if (ret < 0) {
					if (blocknumindex < blocknum) {
						fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
						return	1;
					}
					goto	_CONVERT_DONE;
				}

				// block file number
				if (blockindex == 1) {
					blocknum = ret;
					blocknumindex = 0;
					printf ("BLOCK NUM:%d\n", blocknum);
				}

				crc = CRC_check(ret);

				// data
				if (outfile.IsOpened()) {
					outfile.Putc(ret);
				}

				blockindex++;
				if (!--blocksize) {
					if (crc) {
						fprintf (stderr, "ERROR : CRCG[(%04X)\n", crc);
						return	1;
					}
					state = DECODE_SEARCHSYNCEXIT;
					blockfile = false;
				}
				break;

			// f[^̃wb_
			case	DECODE_DATAHEADER:
				ret = ReadByte();
				if (ret < 0) {
					if (blocknumindex < blocknum) {
						fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
						return	1;
					}
					goto	_CONVERT_DONE;
				}

				if (blockindex < sizeof(BLOCKINFO)) {
					blockinfoptr[blockindex] = ret;
				}

				crc = CRC_check (ret, blockstart);	// b
				blockstart = false;

				// data
				if (outfile.IsOpened()) {
					outfile.Putc(ret);
				}

				blockindex++;
				if (!--blocksize) {
					blocksize = blockinfo.size[1] * 256 + blockinfo.size[0] + 2;
//					printf ("BLOCK FLAG:%02X\n", blockinfo.flag);

					if (blockinfo.flag == 0x00) {
//						printf ("BLOCK FLAG: INFORMATION (%02X) MSX/MZ-1500\n", blockinfo.flag);
					} else
					if (blockinfo.flag == 0x02) {
//						printf ("BLOCK FLAG: INFORMATION (%02X) MZ-1500 ASCII SAVE\n", blockinfo.flag);
					} else
					if (blockinfo.flag == 0x03) {
//						printf ("BLOCK FLAG: BSD DATA (%02X) MSX\n", blockinfo.flag);
					} else
					if (blockinfo.flag == 0x05) {
//						printf ("BLOCK FLAG: DATA BLOCK (%02X)\n", blockinfo.flag);
					} else
					if (blockinfo.flag == 0x07) {
//						printf ("BLOCK FLAG: BSD DATA (Last block) (%02X)\n", blockinfo.flag);
					}

					if (blockinfo.flag > 0x07) {
						fprintf (stderr, "ERROR: Unknown block type (%02X)\n", blockinfo.flag);
						return	0;
					}

//					printf ("BLOCK SIZE:%04X\n", blocksize);

					state = DECODE_DATAFILE;
					blockindex = 0;
				}
				break;

			// f[^̖{
			case	DECODE_DATAFILE:
				ret = ReadByte();
				if (ret < 0) {
					if (blocknumindex < blocknum) {
						fprintf (stderr, "ERROR : t@C̏I[ɒB܂B\n");
						return	1;
					}
					goto	_CONVERT_DONE;
				}

				// INFORMATION BLOCK
				if (!(blockinfo.flag & 0x01)) {
					if (blockindex < sizeof(INFOBLOCK)) {
						infoptr[blockindex] = ret;
					}
				} else {
					if (mztmode && (blocksize > 2)) {
						mztfile.Putc (ret);
					}

					if (splitdumpmode && (blocksize > 2)) {
						// BSD͐擪2oCgEOF܂ŏo
						if (info.attribute == 0x03) {
							if (ret == 0x1A) {	// EOF
								eoffile = true;
								splitfile.Close();
							}
							if (!eoffile && (blockindex >= 2)) {
								splitfile.Putc (ret);
							}
						} else {
							splitfile.Putc (ret);
						}
					}
				}

				crc = CRC_check (ret, blockstart);	// b
				blockstart = false;

				// data
				if (outfile.IsOpened()) {
					outfile.Putc(ret);
				}

				blockindex++;
				if (!--blocksize) {
					if (crc) {
						fprintf (stderr, "ERROR : CRCG[(%04X)\n", crc);
						return	1;
					}

					if (!(blockinfo.flag & 0x01)) {
						splitfile.Close ();
						eoffile = false;

						if (splitdumpmode) {
							char	fname[1024];
							std::string	name = Pathlib::SplitFilename (filename);
							sprintf (fname, "%s.%02d.QDINFO", name.c_str(), blocknumindex);

							if (!splitfile.Open (fname, "wb")) {
								fprintf (stderr, "ERROR : file open error (%s)\n", fname);
								return	1;
							}

							if (!splitfile.Write (&info, sizeof(info))) {
								fprintf (stderr, "ERROR : file write error (%s)\n", fname);
								return	1;
							}

							splitfile.Close();
						}

						// PRINT INFO
						char	fname[256];
						char*	fp = fname;

						// t@C̈Sĕ\
						for (int i = 0; i < sizeof(info.filename); i++) {
							if (info.filename[i] == '%') {
								*fp++ = '%';	// percent encoding
								*fp++ = '%';
							} else
							if (info.filename[i] >= 0x20) {
								*fp++ = info.filename[i];
							} else {
								uint8_t	nibble;
								*fp++ = '%';	// percent encoding
								nibble = (info.filename[i] >> 4);
								nibble = (nibble < 10) ? '0'+nibble : 'A'+nibble-10;
								*fp++ = nibble;
								nibble = info.filename[i] & 0x0F;
								nibble = (nibble < 10) ? '0'+nibble : 'A'+nibble-10;
								*fp++ = nibble;
							}
						}
						*fp++ = '\0';

						printf ("FILE INFORMATION\n");
						printf ("NAME:%s\n", fname);
						printf ("ATTR:%02X\n", info.attribute);
						printf ("SIZE:%04X\n", info.filesize[1] * 256 + info.filesize[0]);
						printf ("LOAD:%04X\n", info.loadaddr[1] * 256 + info.loadaddr[0]);
						printf ("EXEC:%04X\n", info.execaddr[1] * 256 + info.execaddr[0]);
						printf ("\n");

						if (mztmode) {
							// create mzt info
							MZTINFO	mztinfo = { info.attribute };
							memcpy (mztinfo.filename, info.filename, sizeof(mztinfo.filename));

							mztinfo.filesize[0] = info.filesize[0];
							mztinfo.filesize[1] = info.filesize[1];

							mztinfo.loadaddr[0] = info.loadaddr[0];
							mztinfo.loadaddr[1] = info.loadaddr[1];

							mztinfo.execaddr[0] = info.execaddr[0];
							mztinfo.execaddr[1] = info.execaddr[1];

							mztinfo.lock = info.lock;
							mztinfo.secret = info.secret;

							if (!mztfile.Write (&mztinfo, sizeof(mztinfo))) {
								fprintf (stderr, "ERROR : file write error.\n");
								return	1;
							}
						}

						if (splitdumpmode) {
							char	fname[1024];
							std::string	name = Pathlib::SplitFilename (filename);
							sprintf (fname, "%s.%02d.QDDATA", name.c_str(), blocknumindex+1);

							if (!splitfile.Open (fname, "wb")) {
								fprintf (stderr, "ERROR : file open error (%s)\n", fname);
								return	1;
							}
						}
					}

					blocknumindex++;
					state = DECODE_SEARCHSYNCEXIT;
				}
				break;

			default:
				break;
		}
	}

_CONVERT_DONE:;
	if (outfile.IsOpened()) {
		// pfBO
		while (outfile.GetSize() < 160*1024/2+16) {
			// Pad
			outfile.Putc(0x00);
		}
	}

	outfile.Close ();
	mztfile.Close ();
	splitfile.Close ();

	printf ("ϊI܂\n");

	return	0;
}

