/*
̃\[XR[h́ABSDCZXłB

Copyright (c) 2014, Norix
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this 
    list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<stdint.h>

#include	<vector>
#include	<string>

#include	"fileio.h"
#include	"pathlib.h"

static
Pathlib	pathlib;

std::vector<uint8_t>	bitstreambuffer;

uint8_t	bitstreamdata = 0;
uint8_t	bitstreamshift = 0;

void	WriteBits(uint8_t bit)
{
	if (bit)
		bitstreamdata |= (1 << bitstreamshift);
	else
		bitstreamdata &= ~(1 << bitstreamshift);

	if (++bitstreamshift >= 8) {
		bitstreambuffer.push_back(bitstreamdata);
		bitstreamdata = 0;
		bitstreamshift = 0;
	}
}

void	FlushBits()
{
	if (bitstreamshift != 0) {
		for ( ; bitstreamshift < 8; ) {
			bitstreamdata &= ~(1 << bitstreamshift);
			bitstreamshift++;
		}

		bitstreambuffer.push_back(bitstreamdata);
		bitstreamdata = 0;
		bitstreamshift = 0;
	}
}

void	MFM_encoder(uint8_t data)
{
	static	uint32_t	xorbits = 0x55550000;

	uint32_t	b = 0;
	for (int i = 0; i < 8; i++) {
		if (data & (1<<i))
			b |= (3 << (i*2));
	}
	b ^= 0x5555;

	xorbits |= b << 16;

	for (int i = 0; i < 16; i++) {
		if (xorbits & (1<<15)) {
			WriteBits(0);
		} else {
			if (xorbits & (1<<16)) {
				WriteBits(1);
			} else {
				WriteBits(0);
			}
		}

		xorbits >>= 1;
	}
}

int	main(int argc, char* argv[])
{
	if (argc < 3) {
		printf ("QD image encoder (C)Norix, 2014\n" );
		printf (" Usage : QDencoder imagefile outname\n");
		return	0;
	}

	CFile	file;
	std::vector<uint8_t>	imgbuffer;

	if (!file.Open(argv[1], "rb")) {
		fprintf (stderr, "ERROR : file not found. [%s]\n", argv[1]);
		return	1;
	}

	imgbuffer.resize(file.GetSize());

	if (!file.Read(&imgbuffer[0], file.GetSize())) {
		fprintf (stderr, "ERROR : file read error.\n");
		return	1;
	}

	file.Close();

	if (imgbuffer.size() < 1024*80+16) {
		fprintf (stderr, "ERROR : file size error.\n");
		return	1;
	}

	const uint8_t	imgheader[16] = {
		'-', 'Q', 'D', ' ', 'f', 'o', 'r', 'm', 'a', 't', '-', 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
	};

	if (memcmp (imgheader, &imgbuffer[0], sizeof(imgheader))) {
		fprintf (stderr, "ERROR : file format error.\n");
		return	1;
	}

	if (!file.Open(argv[2], "wb")) {
		fprintf (stderr, "ERROR : file open error. [%s]\n", argv[2]);
		return	1;
	}

	// Encode MFM
	bitstreambuffer.clear();
	for (int i = 16; i < imgbuffer.size(); i++) {
		MFM_encoder(imgbuffer[i]);
	}
	FlushBits();

	if (!file.Write(&bitstreambuffer[0], bitstreambuffer.size())) {
		fprintf (stderr, "ERROR : file write error.\n");
		return	1;
	}

	file.Close();

	printf ("Complete.\n");

	return	0;
}
